using System;
using System.Runtime.InteropServices;

namespace Sony
{
	namespace NP
	{
		public enum ErrorCode
		{
			NP_OK,
			NP_SIGNED_IN_FLIGHT_MODE,				// Sign in was successful but the Vita is in flight mode.
			NP_ERR_BUSY,							// A service is busy so cannot accept the request.
			NP_ERR_FAILED,							// General failure, check the log for more info.
			NP_ERR_NOT_SUPPORTED,					// Not supported on this platform.
			NP_ERR_BAD_STATE,						// Somethings gone wrong with the logic, most likely a bug in the UnityNpToolkit code.
			NP_ERR_NOT_SIGNED_IN,					// User is not signed in.
			NP_ERR_NOT_CONNECTED,					// No network connection.
			NP_ERR_NOT_CONNECTED_FLIGHT_MODE,		// No network connection, flight mode is enabled.
			NP_ERR_INDEX_OUT_OF_RANGE,				// An out of range array index was specified.
			NP_ERR_AUTH_NO_CACHED_TICKET,			// A ticket has not yet been cached.
			NP_ERR_TUS_NO_VAR_DATA,					// Getting a cached TUS variable but the variable data does not exist.
		}

		[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 0)]
		public struct ResultCode
		{
			IntPtr _serviceName;
			public ErrorCode lastError;
			public int lastErrorSCE;
			public string className
			{
				get { return Marshal.PtrToStringAnsi(_serviceName); }
			}
		}
	}
}
